﻿using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TestApp.Models
{
    public enum FriendStatus
    {
        Offline,
        Online,
        Away,
        Hidden,
        DoNotDisturb
    }

    public class Friend : BaseEntity<Friend>
    {
        public Friend() : base(null, null) { }

        public Friend(int userID, int otherUserID) : base(userID, otherUserID)
        {
            
        }

        public int UserID
        {
            get { return int.Parse(PartitionKey); }
        }

        public int OtherUserID
        {
            get { return int.Parse(RowKey); }
        }

        public string OtherUserName { get; set; }

        public int OtherUserRegionID { get; set; }

        public FriendStatus OtherUserStatus { get; set; }

        public DateTime OtherUserStatusDate { get; set; }

        public int OtherUserAvatar { get; set; }
        
    }
}
