﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;
using TestApp.Models;

namespace TestApp
{
    class Program
    {
        static void Main(string[] args)
        {

            Console.WriteLine("What would you like to do?");
            Console.WriteLine("1. Test inserting friends.");
            Console.WriteLine("2. Test retrieving friends.");
            var selectedOption = Console.ReadKey(true).Key;
            
            var ownerUserID = 1;
            var numberToInsert = 100;

            switch (selectedOption)
            {
                case ConsoleKey.D1:
                    ;
                    RunTimedAction("Wiping friends list for " + ownerUserID, () => Friend.BulkDeleteByPartionKey(ownerUserID.ToString()));
                    RunTimedAction("Inserting " + numberToInsert + " friends list for " + ownerUserID, () => DoInsertFriends(ownerUserID, numberToInsert));
                    break;

                case ConsoleKey.D2:
                    RunTimedAction("Retrieving friends list for " + ownerUserID, () => DoRetrieveFriends(ownerUserID));
                    break;                    
            }

            Console.ReadKey();
        }

        private static Random _random = new Random(DateTime.UtcNow.Millisecond);

        private static void RunTimedAction(string description, Func<int> action)
        {
            var sw = Stopwatch.StartNew();
            var numberOfEntities = action();
            var seconds = sw.Elapsed.TotalSeconds;
            var queriesPerSecond = numberOfEntities / seconds;
            Console.WriteLine("[" + description + "] Finished " + numberOfEntities + " entities in " + seconds.ToString("###,##0.00") + " seconds, for " + queriesPerSecond.ToString("###,##0.00") + " queries per second.");
        }

       
        private static int DoInsertFriends(int ownerUserID, int numberToInsert)
        {
            using (var x = new CurseAzureContext(1, 2))
            {
                friend.Insert();
                
            }

            for (var i = 0; i < numberToInsert; i++)
            {
                var otherUserID = _random.Next(1000, Int32.MaxValue);
                var friend = new Friend(ownerUserID, otherUserID);
                friend.OtherUserName = "User-" + otherUserID;
                friend.OtherUserRegionID = 1;
                friend.OtherUserStatus = FriendStatus.Offline;
                friend.OtherUserStatusDate = DateTime.UtcNow;
                friend.Insert();
                
            }

            return numberToInsert;
        }

        private static int DoRetrieveFriends(int ownerUserID)
        {
            var allMyFriends = Friend.GetAllByPartitionKey(ownerUserID.ToString());

            foreach (var friend in allMyFriends)
            {
                //Console.WriteLine(friend.OtherUserName);
            }

            return allMyFriends.Count();
        }
    }
}
