﻿using Aerospike.Client;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.Aerospike.Tests.Models
{

    public enum TestStatus
    {
        Unknown,
        Normal,
        Good,
        Awesome
    }

    [TableDefinition(KeySpace = "CurseVoice", TableName = "Test", ReplicationMode = ReplicationMode.None)]
    public class Test : BaseTable<Test>
    {
        [Column("UserID", KeyOrdinal = 1, IsIndexed = true)]
        public int UserID
        {
            get;
            set;
        }

        [Column("OtherUserID", KeyOrdinal = 2, IsIndexed = true)]
        public int OtherUserID
        {
            get;
            set;
        }

        [Column("Name")]
        public string Name
        {
            get;
            set;
        }

        [Column("Status")]
        public TestStatus Status
        {
            get;
            set;
        }

        [Column("Timestamp")]
        public DateTime Timestamp
        {
            get;
            set;
        }

        [Column("IsOnline")]
        public bool IsOnline
        {
            get;
            set;
        }

        [Column("FriendIDs")]
        public HashSet<int> FriendIDs
        {
            get;
            set;
        }

        [Column("TestSet", IsLargeSet = true)]
        public LargeDictionary<int, string> TestLargeDictionary
        {
            get;
            set;
        }

        [Column("TestLargeList", IsLargeSet = true)]
        public LargeList<TestMessage> TestLargeList
        {
            get;
            set;
        }

        [Column("TestDictionary")]
        public Dictionary<int, TestSubField> TestDictionary
        {
            get;
            set;
        }  
    }
}
