﻿using System;
using System.Collections.Generic;

namespace Curse.Aerospike.Tests.Models
{
    public class TestMessage : ILargeListElement
    {
        public Guid ID { get; set; }        
        public string Body { get; set; }
        public DateTime Timestamp { get; set; }
        public int SenderID { get; set; }

        public long GetKey()
        {
            return Timestamp.ToEpoch();
        }

        public Dictionary<object, object> ToHash()
        {
            return new Dictionary<object, object>
            {
                { "id", ID },
                { "body", Body },
                { "timestamp", Timestamp },
                { "sender", SenderID },
            };
        }

        public void Hydrate(Dictionary<object, object> hash)
        {
            object value;
            if (hash.TryGetValue("id", out value))
            {
                ID = (Guid)value;
            }

            if (hash.TryGetValue("body", out value))
            {
                Body = (string) value;
            }

            if (hash.TryGetValue("timestamp", out value))
            {
                Timestamp = (DateTime) value;
            }

            if (hash.TryGetValue("sender", out value))
            {
                SenderID = Convert.ToInt32(value);
            }
        }
    }
}
