﻿using Aerospike.Client;
using System;
using System.Collections.Generic;
using System.Linq;

namespace Curse.Aerospike.Tools
{
    public class AerospikeCluster : IDisposable
    {
        public AerospikeCluster(string name, HashSet<string> typeNames, string[] ipAddresses)
        {
            Name = name;
            var hosts = ipAddresses.Select(p => new Host(p, 3000)).ToArray();
            var clientPolicy = new ClientPolicy();
            clientPolicy.queryPolicyDefault = new QueryPolicy { timeout = 30000, consistencyLevel = ConsistencyLevel.CONSISTENCY_ALL };
            clientPolicy.readPolicyDefault = new Policy { timeout = 10000, consistencyLevel = ConsistencyLevel.CONSISTENCY_ALL };
            clientPolicy.writePolicyDefault = new WritePolicy { timeout = 20000 };
            Client = new AerospikeClient(clientPolicy, hosts);
            Namespaces = new List<AerospikeNamespace>();
            SetNames = typeNames;
        }

        public AerospikeClient Client
        {
            get;
            set;
        }

        public string Name { get; private set; }

        public HashSet<string> SetNames { get; set; } 

        public List<AerospikeNamespace> Namespaces
        {
            get;
            set;
        }

        public void Dispose()
        {
            var client = Client;
            if (client != null)
            {
                client.Close();
            }
            Client = null;
        }

        public void AddNamespace(string name)
        {
            Namespaces.Add(new AerospikeNamespace(this, name));
        }

        public void ReloadNamespaces()
        {
            foreach (var ns in Namespaces)
            {
                ns.ReloadSets(SetNames);
            }
        }
    }
}
