﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.Aerospike.Tools
{
    public class AerospikeEnvironment : IDisposable
    {
        public string Name { get; set; }

        public List<AerospikeCluster> Clusters { get; set; }

        public AerospikeEnvironment(string name, IEnumerable<AerospikeCluster> clusters)
        {
            Name = name;
            Clusters = new List<AerospikeCluster>(clusters);
        }

        public void Dispose()
        {
            foreach (var cluster in Clusters)
            {
                cluster.Dispose();
            }
        }
    }
}
