﻿using System.Collections.Generic;
using System.Linq;
using Curse.Aerospike.Tools.Configuration;

namespace Curse.Aerospike.Tools
{
    public class AerospikeNamespace : PropertyNotifier
    {
        public AerospikeNamespace(AerospikeCluster parent, string name)
        {
            Parent = parent;
            Name = name;

            ReloadSets(parent.SetNames);
        }

        public AerospikeCluster Parent
        {
            get;
            private set;
        }

        public string Name
        {
            get;
            private set;
        }

        private List<AerospikeSet> _sets;
        public List<AerospikeSet> Sets
        {
            get { return _sets; }
            private set
            {
                if (_sets != value)
                {
                    _sets = value;
                    OnPropertyChanged();
                }
            }
        }

        public void ReloadSets(HashSet<string> setNames)
        {
            Sets = AerospikeModel.GetModelsForNamespace(Name, setNames)
                .Select(m => new AerospikeSet(this, m.Name, m.KeyProperties, m.IndexedProperties))
                .OrderBy(m=>m.Name).ToList();
        }
    }
}
