﻿using System.Windows;
using Aerospike.Client;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using Curse.Aerospike.Tools.Configuration;
using Curse.Aerospike.Tools.Filtering;

namespace Curse.Aerospike.Tools
{
    public class AerospikeSet : PropertyNotifier
    {
        public AerospikeSet(AerospikeNamespace parent, string name, List<KeyProperty> keyProperties,
            List<IndexedProperty> indexedProperties)
        {
            Parent = parent;
            Name = name;

            AvailableQueries = new[]
            {
                AerospikeQuery.CreateNonFilteringQuery(),
                AerospikeQuery.CreateKeyQuery(keyProperties)
            }.Concat((indexedProperties ?? new List<IndexedProperty>()).Select(AerospikeQuery.CreateQuery)).ToList();
            
            ActiveQuery = AvailableQueries.First();
        }

        public Key GetKey(DataRow row)
        {
            return row[0] as Key;            
        }

        public AerospikeNamespace Parent
        {
            get;
            set;
        }

        public string Name
        {
            get;
            set;
        }

        private DataView _dataView;
        public DataView DataView
        {
            get{return _dataView;}
            set
            {
                if (_dataView != value)
                {
                    _dataView = value;
                    OnPropertyChanged();
                }
            }
        }

        public AerospikeQuery ActiveQuery
        {
            get; 
            set;
        }

        public List<AerospikeQuery> AvailableQueries
        {
            get; 
            set;
        }

        public void LoadData(bool forceLoad = false)
        {
            if(DataView != null &&  !forceLoad)
            {
                return;
            }

            var query = ActiveQuery;
            var results = query.Run(this, DataView == null ? null : DataView.Sort);
            if (results.IsTruncated)
            {
                MessageBox.Show(
                    string.Format("There are more than {0} records in this set. Only the first {0} will be shown.",
                        AerospikeQuery.MaxTableRows),
                    "Large Set Warning", MessageBoxButton.OK, MessageBoxImage.Warning);
            }

            DataView = results.DataView;
        }
    }
}
