﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;

namespace Curse.Aerospike.Tools.Configuration
{
    [Serializable]
    public class AerospikeModelCollection
    {
        private List<AerospikeModel> _models = new List<AerospikeModel>();

        public List<AerospikeModel> Models
        {
            get { return _models; }
            set
            {
                {
                    _models = value;
                }
            }
        }

        public void Add(AerospikeModel model)
        {
            var oldModel = _models.FirstOrDefault(m => m.Name == model.Name);
            _models.Remove(oldModel);
            _models.Add(model);
        }
    }
}
