﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;

namespace Curse.Aerospike.Tools.Configuration
{
    public static class ConfigurationHelper
    {

        public static T[] LoadConfigurations<T>(string configPath)
        {
            var di = new DirectoryInfo(configPath);
            var files = di.GetFiles("Aerospike.*");
            var configs = new List<T>();
            foreach (var file in files)
            {
                var config = LoadConfiguration<T>(file.FullName);
                configs.Add(config);
            }

            return configs.ToArray();
        }

        public static T LoadConfiguration<T>(string configPath)
        {
           
            using (var reader = new StreamReader(configPath))
            {
                var dcs = new XmlSerializer(typeof(T));
                return (T)dcs.Deserialize(reader);
            }

        }
    }
}
