using System;
using System.Xml.Serialization;

namespace Curse.Aerospike.Tools.Configuration
{
    [Serializable]
    public class IndexedProperty
    {
        public string Name { get; set; }

        private Type _dataType;
        [XmlIgnore]
        public Type DataType
        {
            get
            {
                _dataType = _dataType == null || _dataType.FullName != TypeName
                    ? Type.GetType(TypeName, true)
                    : _dataType;
                return _dataType;
            }
            internal set
            {
                _dataType = value;
                TypeName = value.FullName;
            }
        }

        public string TypeName{ get; set; }
    }
}