﻿using System;
using System.Collections.Generic;
using System.Linq;
using Aerospike.Client;
using Curse.Aerospike.Tools.Configuration;

namespace Curse.Aerospike.Tools.Filtering
{
    public class KeyLookupQuery : AerospikeQuery
    {
        private const string KeyDelimeter = "-";

        public List<KeyPart> OrderedKeyProperties { get; private set; }
 
        public KeyLookupQuery(List<KeyProperty> keyProperties) : base("Key")
        {
            OrderedKeyProperties = keyProperties.OrderBy(k => k.Ordinal).Select(KeyPart.CreateKeyPart).ToList();
        }

        public override QueryResults Run(AerospikeSet set, string sortColumn = null)
        {
            return Get(set, new Key(set.Parent.Name, set.Name, GetKeyString()));
        }

        private string GetKeyString()
        {
            return string.Join(KeyDelimeter, (from p in OrderedKeyProperties let value = p.GetKeyValue() where !p.IsDefault() || !p.IsOptional select value).ToArray());
        }

    }
}
