﻿using System;
using Curse.Aerospike.Tools.Configuration;

namespace Curse.Aerospike.Tools.Filtering
{
    public abstract class KeyPart
    {
        public string Name { get; private set; }

        public bool IsOptional { get; private set; }

        protected KeyPart(string propertyName, bool isOptional)
        {
            Name = propertyName;
            IsOptional = isOptional;
        }

        public abstract string GetKeyValue();

        public abstract bool IsDefault();

        public static KeyPart CreateKeyPart(KeyProperty property)
        {
            if (property.DataType.IsAssignableFrom(typeof (string))
                || property.DataType.IsAssignableFrom(typeof (Guid))
                || property.DataType.IsAssignableFrom(typeof(AerospikeEnum)))
            {
                return new StringKeyPart(property.Name, property.IsOptional);
            }
            else
            {
                return new LongKeyPart(property.Name, property.IsOptional);
            }
        }
    }
}