﻿using Aerospike.Client;

namespace Curse.Aerospike.Tools.Filtering
{
    internal class LongQuery : AerospikeQuery
    {
        public bool UseExactMatch { get; set; }
        public long ExactValue { get; set; }

        public bool UseLowerBound { get; set; }
        public long LowerBound { get; set; }

        public bool UseUpperBound { get; set; }
        public long UpperBound { get; set; }

        public LongQuery(string binName) : base(binName)
        {
        }

        public override QueryResults Run(AerospikeSet set, string sortColumn = null)
        {
            Filter filter;
            if (UseExactMatch)
            {
                filter = Filter.Equal(BinName, ExactValue);
            }
            else
            {
                filter = Filter.Range(BinName, 
                    UseLowerBound ? LowerBound : long.MinValue,
                    UseUpperBound ? UpperBound : long.MaxValue);
            }

            return Query(set, filter, sortColumn);
        }
    }
}
