﻿namespace Curse.Aerospike.Tools.Filtering
{
    public class StringKeyPart : KeyPart
    {
        public string Value { get; set; }

        public override string GetKeyValue()
        {
            return string.IsNullOrWhiteSpace(Value) ? "<null>" : Value;
        }

        public override bool IsDefault()
        {
            return Value == null;
        }

        public StringKeyPart(string propertyName, bool isOptional) : base(propertyName, isOptional)
        {
        }
    }
}