﻿using System;

namespace Curse.Aerospike
{
    public class ColumnAttribute : Attribute
    {        
        public ColumnAttribute(string name)
        {
            if(name.Length > 14)
            {
                throw new InvalidOperationException("Column name '" + name + "' cannot exceed 14 characters!");
            }
            Name = name;
            
        }

        public string Name
        {
            get;
            set;
        }

        public int KeyOrdinal
        {
            get;
            set;
        }

        public bool IsIndexed
        {
            get;
            set;
        }


        public bool IsOptional
        {
            get;
            set;
        }

        public bool IsLargeSet { get; set; }
    }
}
