﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using Aerospike.Client;

namespace Curse.Aerospike
{
    public class LargeDictionary<K, V>
    {
        private readonly LargeMap _map;
        private readonly Func<object, K> _keyConverter;
        private readonly Func<object, V> _valueConverter;
        
        public LargeDictionary(LargeMap map, Func<object, K> keyConverter, Func<object, V> valueConverter)
        {
            _map = map;            
            _keyConverter = keyConverter;
            _valueConverter = valueConverter;
        }

        public void Add(K key, V value)
        {           
            _map.Put(Value.Get(key), Value.Get(value));

            if (_values != null)
            {                
                _values[key] = value;                
            }
        }

        public void BulkAdd(Dictionary<K, V> dictionary)
        {
            _map.Put(dictionary);            
        }

        public void Remove(K key)
        {
            _map.Remove(Value.Get(key));

            if (_values != null)
            {
                _values.Remove(key);
            }
        }

        public void Clear()
        {                        
            _map.Destroy();
            _map.Put(new Dictionary<K, V>());
            _values = null;
        }

        public void Get(K key)
        {            
            _map.Get(Value.Get(key));
        }

        private Dictionary<K, V> _values;
        private readonly object _syncRoot = new object();

        public Dictionary<K, V> Values
        {
            get
            {
                lock (_syncRoot)
                {
                    if (_values != null)
                    {
                        return _values;
                    }

                    IDictionary mapItems;
                    try
                    {                        
                        mapItems = _map.Scan();                        
                    }
                    catch
                    {
                        _values = new Dictionary<K, V>();
                        return _values;
                    }
                    
                    var dict = new Dictionary<K, V>();

                    foreach (DictionaryEntry kvp in mapItems)
                    {
                        dict.Add(_keyConverter(kvp.Key), _valueConverter(kvp.Value));
                    }

                    _values = dict;

                    return _values;
                }
            }
        }

        public int Count         
        {
            get { return _map.Size(); }        
        }
    }
}
