﻿using Microsoft.ApplicationServer.Caching;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.AzureCaching
{
    public class AzureCacheManager
    {
        public static DataCache DefaultCache;

        static AzureCacheManager()
        {
            DefaultCache = new DataCache("default");
        }

        public static T GetOrAdd<T>(string key, Func<T> setter) where T : class
        {            
            var value = DefaultCache.Get(key) as T;

            if(value == null)
            {
                value = setter();
                if (value != null)
                {
                    DefaultCache.Add(key, value);
                }
            }
                        
            return value;
        }
      
    }
}
