﻿using Microsoft.WindowsAzure.Storage;
using Microsoft.WindowsAzure.Storage.Auth;
using Microsoft.WindowsAzure.Storage.Queue;
using Microsoft.WindowsAzure.Storage.Table;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.AzureData
{
    public class AzureClientHelper
    {

        private static readonly Dictionary<int, AzureStorageConfiguration> _configurationByID = new Dictionary<int, AzureStorageConfiguration>();
        private static readonly Dictionary<string, List<AzureStorageConfiguration>> _configurationByGroup = new Dictionary<string, List<AzureStorageConfiguration>>();

        private AzureClientHelper()
        {
            
        }

       
        public static void Initialize(string localStorageRegion, IEnumerable<AzureStorageConfiguration> configurations)
        {
            foreach(var configuration in configurations)
            {
                if (configuration.StorageRegion.Equals(localStorageRegion))
                {
                    LocalStorageID = configuration.StorageID;
                }

                _configurationByID.Add(configuration.StorageID, configuration);
                List<AzureStorageConfiguration> byGroup;
                if(!_configurationByGroup.TryGetValue(configuration.StorageRegion, out byGroup))
                {
                    byGroup = new List<AzureStorageConfiguration>();
                    _configurationByGroup.Add(configuration.StorageRegion, byGroup);
                }
                byGroup.Add(configuration);
            }

            RemoteStorageIDs = configurations.Where(p => p.StorageID != LocalStorageID).Select(p => p.StorageID).ToArray();
            AllStorageIDs = configurations.Select(p => p.StorageID).ToArray();
        }

        public static CloudTableClient GetClient(int storageID)
        {
            AzureStorageConfiguration configuration = null;

            if (!_configurationByID.TryGetValue(storageID, out configuration))
            {
                throw new NotImplementedException("Unknown storage ID: " + storageID);
            }

            CloudStorageAccount account = configuration.IsDevelopment ? CloudStorageAccount.DevelopmentStorageAccount
               : new CloudStorageAccount(new StorageCredentials(configuration.AccountName, configuration.AccountPassword), true);
            
            return account.CreateCloudTableClient();
        }

        public static int LocalStorageID
        {
            get;
            private set;
        }

        public static int[] AllStorageIDs
        {
            get; 
            private set;
        }

        public static int[] RemoteStorageIDs
        {
            get;
            private set;
        }

        public static CloudQueueClient GetQueueClient(int storageID)
        {
            AzureStorageConfiguration configuration = null;

            if (!_configurationByID.TryGetValue(storageID, out configuration))
            {
                throw new NotImplementedException("Unknown storage ID: " + storageID);
            }
                        
            CloudStorageAccount account = configuration.IsDevelopment ? CloudStorageAccount.DevelopmentStorageAccount 
                : new CloudStorageAccount(new StorageCredentials(configuration.AccountName, configuration.AccountPassword), true);
                        
            return account.CreateCloudQueueClient();
        }
    }
}
