﻿using Microsoft.WindowsAzure.Storage.Queue;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.AzureData
{
    public static class AzureUtility
    {
        public static bool IsAllowedQueueMessageSize(string value)
        {
            return IsAllowedQueueMessageSize(System.Text.Encoding.UTF8.GetByteCount(value));
        }

        public static bool IsAllowedQueueMessageSize(long size)
        {
            return size >= 0 && size <= (CloudQueueMessage.MaxMessageSize - 1) / 4 * 3;
        }
    }
}
