﻿using Curse.Friends.Data;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Curse.Friends.WebService
{
    public class FriendshipContextException : Exception
    {
        public FriendshipContextException(string message) : base(message)
        {

        }
    }

    public class FriendshipContext
    {
        public UserRegion MyRegion
        {
            get;
            set;
        }

        public User Me
        {
            get;
            set;
        }

        public UserRegion TheirRegion
        {
            get;
            set;
        }

        public User Them
        {
            get;
            set;
        }

        public FriendshipContext(int myUserID, int theirUserID)
        {
            if (myUserID == theirUserID)
            {
                throw new FriendshipContextException("Requesting user cannot interact with theirself.");
            }

            MyRegion = UserRegion.Find(myUserID);

            if (MyRegion == null)
            {
                throw new FriendshipContextException("Unable to find requesting user's region: " + myUserID);
            }

            TheirRegion = UserRegion.Find(theirUserID);

            if(TheirRegion == null)
            {
                throw new FriendshipContextException("Unable to find other user's region: " + theirUserID);
            }

            Me = User.Get(MyRegion.RegionID, myUserID);

            if (Me == null)
            {
                throw new FriendshipContextException("Unable to retrieve requesting user: " + myUserID + " from region: " + MyRegion.RegionID);
            }


            Them = User.Get(TheirRegion.RegionID, theirUserID);

            if (Them == null)
            {
                throw new FriendshipContextException("Unable to retrieve other user: " + theirUserID + " from region: " + TheirRegion.RegionID);
            }

        }


        public Friendship GetMyFriendship()
        {
            return Friendship.Get(MyRegion.RegionID, Me.UserID, Them.UserID);
        }

        public Friendship GetTheirFriendship()
        {
            return Friendship.Get(TheirRegion.RegionID, Them.UserID, Me.UserID);
        }
    }
}