﻿using Curse.CloudServices.Authentication;
using Curse.Friends.Requests;
using Curse.Friends.Responses;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;

namespace Curse.Friends
{
    // NOTE: You can use the "Rename" command on the "Refactor" menu to change the interface name "IService1" in both code and config file together.
    [ServiceContract]
    public interface IFriendsService
    {

        [OperationContract]
        AddFriendHintResponse AddFriendHint(FriendHintRequest hint);

        [OperationContract]
        GetSelfHintsResponse GetSelfHints();

        [OperationContract]
        GetMyFriendsResponse GetMyFriends();

        [OperationContract]
        RequestFriendshipResponse RequestFriendship(FriendshipRequest request);

        [OperationContract]
        ConfirmFriendshipResponse ConfirmFriendship(ConfirmFriendshipRequest request);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        RegisterSelfResponse RegisterSelf(RegisterSelfRequest request);


        [OperationContract]
        IEnumerable<string> DebugCreateEntities(int seedID, int numberToCreate);
        
#if DEBUG
        [OperationContract]
        void DebugAddFriend(int otherUserID);
#endif
        
    }
   
}
