﻿using Curse.Friends.Data;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Curse.Friends.Requests
{
    public class FriendshipRequest : BaseRequestContract
    {
        public int FriendID
        {
            get;
            set;
        }

        public string KnownIdentity
        {
            get;
            set;
        }

        public string InvitationMessage
        {
            get;
            set;
        }

        public override bool Validate()
        {
            if(FriendID <= 0)
            {
                _validationMessage = "Invalid FriendID";
                return false;
            }

            if (string.IsNullOrEmpty(KnownIdentity) || KnownIdentity.Length > Friendship.OtherUserNicknameMaxLength)
            {
                _validationMessage = "KnownIdentity must be supplied, and less than " + Friendship.OtherUserNicknameMaxLength + " characters.";
                return false;
            }

            if (!string.IsNullOrEmpty(InvitationMessage) && InvitationMessage.Length > Friendship.InvitationMaxLength)
            {
                _validationMessage = "InvitationMessage must be empty, or less than " + Friendship.InvitationMaxLength + " characters.";                
                return false;
            }
            
            return true;
        }
    }
}