﻿using Curse.Friends.Data;
using Curse.SocketInterface;
using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.NotificationWorker
{
    public class NotificationInstance
    {
        private readonly ConcurrentDictionary<string, NotificationSession> _sessionsBySessionID = new ConcurrentDictionary<string, NotificationSession>();

        public NotificationSession GetSession(string sessionID)
        {
            NotificationSession value;
            
            if(_sessionsBySessionID.TryGetValue(sessionID, out value))
            {
                return value;
            }

            return null;
        }

        public void ClientDisconnected(NotificationSession disconnectedSession)
        {
            // Remove this session from our list
            NotificationSession removedSession;
            if (!_sessionsBySessionID.TryRemove(disconnectedSession.SessionID, out removedSession))
            {
                return;
            }
        }

        public NotificationSession CreateSession(BaseSocketInterface socketInterface, int userID, string machineKey, string sessionID)
        {

            var endpoint = ClientEndpoint.GetLocal(userID, machineKey);

            if(endpoint == null)
            {
                return null;
            }

            if(!endpoint.SessionID.Equals(sessionID))
            {
                return null;
            }

            ClientEndpoint.SetConnected(ClientEndpoint.LocalConfigID, Environment.MachineName, userID, machineKey);

            var session = new NotificationSession(this, socketInterface, sessionID, userID, machineKey);
            _sessionsBySessionID.TryAdd(sessionID, session);
            return session;
        }

    }
}
