﻿using Curse.SocketInterface;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Friends.NotificationContracts;
using Curse.Friends.Data;
using Curse.Friends.Enums;

namespace Curse.NotificationWorker
{
    public class NotificationSession : ISocketSession
    {

        public NotificationSession(NotificationInstance parent, BaseSocketInterface serverSocket, string sessionID, int userID, string machineKey)
        {
            Parent = parent;            
            ServerSocket = serverSocket;
            SessionID = sessionID;
            UserID = userID;
            MachineKey = machineKey;
        }

        public NotificationInstance Parent { get; private set; }
        public BaseSocketInterface ServerSocket { get; private set; }
        public string SessionID { get; private set; }
        public int UserID { get; private set; }
        public string MachineKey { get; private set; }

        public void Disconnect()
        {
            Parent.ClientDisconnected(this);
            UserStatusResolver.Enqueue(new UserStatusResolver 
            {
                ResolveStatus = true, 
                UserID = UserID, 
                MachineKey = MachineKey,                 
                Status = UserConnectionStatus.Offline 
            });
        }

        public void NotifyUserStatus(UserStatusNotification notification)
        {
            ServerSocket.SendContract(notification);
        }

        public void NotifyFriendship(FriendshipNotification notification)
        {
            ServerSocket.SendContract(notification);
        }

        public void NotifyVoiceInvitation(VoiceInvitationNotification notification)
        {
            ServerSocket.SendContract(notification);
        }

    }
}
