using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Net;
using System.Threading;
using Microsoft.WindowsAzure;
using Microsoft.WindowsAzure.Diagnostics;
using Microsoft.WindowsAzure.ServiceRuntime;
using Curse.Friends.Configuration;
using Curse.Friends.Data;

namespace Curse.NotificationWorker
{
    public class WorkerRole : RoleEntryPoint
    {
        public override void Run()
        {            

            // This is a sample worker implementation. Replace with your logic.
            Trace.TraceInformation("Curse.NotificationWorker entry point called");   
            while(true)
            {
                Thread.Sleep(Timeout.Infinite);
            }
        }

        public override bool OnStart()
        {

            StorageConfiguration.Initialize();

            var endpoints = RoleEnvironment.CurrentRoleInstance.InstanceEndpoints;

            // Set the maximum number of concurrent connections 
            ServicePointManager.DefaultConnectionLimit = 12;

            NotificationServer.Instance.Start(new IPEndPoint[] { new IPEndPoint(IPAddress.Parse("0.0.0.0"), 81) });

            return base.OnStart();
        }

        public override void OnStop()
        {
            NotificationServer.Instance.Stop(); 
            base.OnStop();
        }
    }
}
