﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Friends.Enums;

namespace Curse.Backend.BehaviorTest
{
    class Device
    {
        public DevicePlatform Platform { get; private set; }
        public string DeviceID { get; private set; }

        private Device(DevicePlatform platform, string deviceID)
        {
            Platform = platform;
            DeviceID = deviceID;
        }

        public static readonly Device Windows = new Device(
            DevicePlatform.Windows, 
            null);

        public static readonly Device iOS = new Device(
            DevicePlatform.iOS,
            "1bf8b92703973d4bc56a6a7a8d32e6ee1d9f728c6f9089a708dc8aaddf6e8504");

        public static readonly Device Android = new Device(
            DevicePlatform.Android,
            "APA91bF35khXTl31nT4ly5agHA_tkU_-RPC1EAdRq1IeQWSfz6D4qU7Beyw9VcRWpGhuxKA7O-bln0b2b4_zkyt03SN3JlYbyjtUQITwtCqBDvC2TlBHSU_TOLwFrFpUpNCqwvmm8kAzyxxR2ECgctTfXfCWXtfj1w");
    }
}
