﻿using System;
using System.Collections.Generic;
using Curse.Friends.Client.FriendsService;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;

namespace Curse.Backend.BehaviorTest
{
    public class Group
    {

        public Group(GroupMembership value)
        {
            GroupID = value.GroupID;
            RootGroupID = value.RootGroupID;
            ParentGroupID = value.ParentGroupID;
            GroupTitle = value.GroupTitle;
            GroupAvatar = value.GroupAvatarUrl;
            MemberCount = value.GroupMemberCount;
            GroupType = value.GroupType;
            GroupRole = value.GroupRole;            
            IsFavorite = value.IsFavorite;
            NotificationPreference = value.NotificationPreference;
            if (value.NotificationFilters != null)
            {
                NotificationFilters = new HashSet<string>(value.NotificationFilters);
            }
            DateMessaged = value.DateMessaged;
        }

        public void UpdateFromNotification(GroupNotification value)
        {
            GroupID = value.GroupID;
            RootGroupID = value.RootGroupID;
            ParentGroupID = value.ParentGroupID;
            DisplayOrder = value.DisplayOrder;

            if (!value.MetaDataOnly)
            {
                GroupTitle = value.GroupTitle;
                GroupAvatar = value.GroupAvatar;
                GroupType = value.GroupType;
                GroupAccessLevel = value.GroupAccessLevel;
                MessageOfTheDay = value.MessageOfTheDay;
            }
        }

        public Group(GroupNotification value)
        {
            UpdateFromNotification(value);
        }

        #region Global Properties

        public string GroupTitle
        {
            get;
            set;
        }
        
        public string GroupAvatar
        {
            get;
            set;
        }

        public Guid GroupID
        {
            get;
            set;
        }

        public Guid ParentGroupID
        {
            get;
            set;
        }

        public Guid RootGroupID
        {
            get;
            set;
        }
        
        public string VoiceSessionCode
        {
            get;
            set;
        }
        
        public string MessageOfTheDay
        {
            get;
            set;
        }

        public bool AllowTempChannels
        {
            get;
            set;
        }

        public GroupRole GroupAccessLevel
        {
            get;
            set;
        }
        
        public GroupType GroupType
        {
            get;
            set;
        }

        public int MemberCount
        {
            get;
            set;
        }

        public int DisplayOrder
        {
            get; 
            set;
        }


        #endregion

        #region User Specific an Properties

        public NotificationPreference NotificationPreference
        {
            get; 
            set;
        }

        public HashSet<string> NotificationFilters
        {
            get;
            set;
        }

        public bool IsFavorite
        {
            get;
            set;
        }

        public GroupRole GroupRole
        {
            get;
            set;
        }

        public DateTime DateMessaged
        {
            get; 
            set;
        }

        #endregion
    }
}
