﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using Curse.Friends.Client.FriendsService;
using Curse.Friends.NotificationContracts;

namespace Curse.Backend.BehaviorTest

{
    public class GroupCache
    {
        public GroupCache(GroupMembership groupMembership)
        {
            Members = new Dictionary<int, GroupMemberNotification>();
            RootGroup = new Group(groupMembership);
            Children = new Dictionary<Guid, Group>();
        }

        public GroupCache(GroupNotification groupNotification)
        {
            Members = new Dictionary<int, GroupMemberNotification>();
            RootGroup = new Group(groupNotification);
            Children = new Dictionary<Guid, Group>();
        }

        //public GroupCache(GroupNotification group, GroupMemberNotification[] members)
        //{

        //    var rootGroup = new Group();
        //    SetGroupFromNotification(rootGroup, group);
        //    RootGroup = rootGroup;
        //    Members = new Dictionary<int, GroupMember>();  
        //    Children = new Dictionary<Guid, Group>();

        //    foreach (var member in members)
        //    {
        //        AddMember(member);
        //    }
        //}

        public void AddChild(Group group)
        {
            Children[group.GroupID] = group;
        }

        public void AddMember(GroupMemberNotification member)
        {
            Members[member.UserID] = member;
        }

        public GroupMemberNotification UpdateMember(GroupMemberNotification update)
        {
            GroupMemberNotification found;

            if (Members.TryGetValue(update.UserID, out found))
            {
                found.Username = update.Username;
                found.CurrentGroupID = update.CurrentGroupID;
                found.Role = update.Role;
            }

            return found;
        }       

        public Group AddOrUpdateGroup(GroupNotification notification)
        {
            if (notification.GroupID == RootGroup.GroupID)
            {
                RootGroup.UpdateFromNotification(notification);
                return RootGroup;
            }

            Group found = null;
            if (Children.TryGetValue(notification.GroupID, out found))
            {
                found.UpdateFromNotification(notification);
            }
            else
            {
                found = new Group(notification);
                Children[notification.GroupID] = found;
            }

            return found;
        }

        public void RemoveChildGroup(Guid groupID)
        {
            Children.Remove(groupID);
        }

        public Group GetGroup(Guid groupID)
        {
            if (groupID == RootGroup.GroupID)
            {
                return RootGroup;
            }

            Group found;
            if (Children.TryGetValue(groupID, out found))
            {
                return found;
            }

            return null;
        }

        public bool ChildExists(GroupNotification notification)
        {
            return Children.ContainsKey(notification.GroupID);
        }

        //private void SetGroupFromNotification(GroupDetails group, GroupNotification notification)
        //{
        //    group.RootGroupID = notification.RootGroupID;
        //    group.ParentGroupID = notification.ParentGroupID;
        //    group.GroupID = notification.GroupID;
        //    group.Title = notification.GroupTitle;
        //    group.AvatarUrl = notification.GroupAvatar;
        //    group.ParentGroupID = notification.ParentGroupID;
        //    group.AccessLevel = notification.GroupAccessLevel; 
        //}

     
        public void AddMembers(GroupMemberNotification[] members)
        {
            foreach (var member in members)
            {
                AddMember(member);
            }
        }

        public GroupMemberNotification RemoverMember(int userID)
        {
            GroupMemberNotification found = null;

            if (Members.TryGetValue(userID, out found))
            {
                Members.Remove(userID);    
            }

            return found;
        }

        public GroupMemberNotification GetMember(int userID)
        {
            GroupMemberNotification found = null;
            Members.TryGetValue(userID, out found);
            return found;
        }

        public bool HasLoadedDetails { get; set; }
        public Group RootGroup { get; set; }
        public Dictionary<int, GroupMemberNotification> Members { get; set; }
        public Dictionary<Guid, Group> Children { get; set; }        
    }
}
