﻿
using System.ServiceModel;
using System.Text;
using System.Threading.Tasks;
using Curse.Backend.BehaviorTest.ClientService;

namespace Curse.Backend.BehaviorTest
{
    public static class TestServiceClientHelper
    {        
        public static CClientServiceClient CreateClientServiceClient(string username, string password, string uri)
        {
            // Set the authentication context
            Curse.ServiceAuthentication.Models.AuthenticationToken.Initialize(username, password);

            // The binding configuration
            var binding = WcfClientHelper.GetCustomBinaryHttpBinding();

            // Create the client            
            var client = new CClientServiceClient(binding, new EndpointAddress(uri));

            // Add the behaviour to send the credentials with each request
            client.ChannelFactory.Endpoint.Behaviors.Add(new Curse.ServiceAuthentication.Models.AuthTokenExtension());

            return client;

        }
    }
}
