﻿using Curse.CloudServices.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.Text;
using System.Threading.Tasks;
using System.Xml;

namespace Curse.Backend.BehaviorTest
{
    class WcfClientHelper
    {
        private static XmlDictionaryReaderQuotas GetDefaultReaderQuotas()
        {
            XmlDictionaryReaderQuotas readerQuotas = new XmlDictionaryReaderQuotas();
            readerQuotas.MaxArrayLength = 16384;
            readerQuotas.MaxBytesPerRead = 4096;
            readerQuotas.MaxNameTableCharCount = 16384;
            readerQuotas.MaxDepth = 64;
            readerQuotas.MaxStringContentLength = 640000;
            return readerQuotas;
        }

        public static BasicHttpBinding GetDefaultBasicHttpBinding()
        {
            // Reader quotas
            XmlDictionaryReaderQuotas readerQuotas = GetDefaultReaderQuotas();

            // Basic Http Binding
            BasicHttpBinding binding = new BasicHttpBinding(BasicHttpSecurityMode.None);
            binding.AllowCookies = false;
            binding.CloseTimeout = TimeSpan.FromSeconds(10);
            binding.OpenTimeout = TimeSpan.FromSeconds(10);
            binding.ReceiveTimeout = TimeSpan.FromSeconds(30);
            binding.SendTimeout = TimeSpan.FromMinutes(5);
            binding.UseDefaultWebProxy = true;
            binding.BypassProxyOnLocal = false;
            binding.HostNameComparisonMode = HostNameComparisonMode.StrongWildcard;
            binding.MaxBufferPoolSize = 524288;
            binding.MaxBufferSize = 6553600;
            binding.MaxReceivedMessageSize = Int32.MaxValue;
            binding.MessageEncoding = WSMessageEncoding.Text;
            binding.TextEncoding = Encoding.UTF8;
            binding.TransferMode = TransferMode.StreamedRequest;
            binding.ReaderQuotas = readerQuotas;

            return binding;
        }

        public static CustomBinding GetCustomBinaryHttpBinding()
        {
            CustomBinding binding = new CustomBinding();

            binding.CloseTimeout = TimeSpan.FromSeconds(10);
            binding.OpenTimeout = TimeSpan.FromSeconds(10);
            binding.ReceiveTimeout = TimeSpan.FromMinutes(1);
            binding.SendTimeout = TimeSpan.FromMinutes(1);

            // Binary Encoding
            BinaryMessageEncodingBindingElement binaryEncoding = new BinaryMessageEncodingBindingElement();
            binaryEncoding.ReaderQuotas.MaxArrayLength = 16384;
            binaryEncoding.ReaderQuotas.MaxBytesPerRead = 4096;
            binaryEncoding.ReaderQuotas.MaxNameTableCharCount = 16384;
            binaryEncoding.ReaderQuotas.MaxDepth = 64;
            binaryEncoding.ReaderQuotas.MaxStringContentLength = 640000;
            binding.Elements.Add(binaryEncoding);

            // Http Transport
            HttpTransportBindingElement httpTransport = new HttpTransportBindingElement();
            httpTransport.AuthenticationScheme = AuthenticationSchemes.Anonymous;
            httpTransport.MaxBufferPoolSize = 524288;
            httpTransport.MaxReceivedMessageSize = 2147483647;
            httpTransport.MaxBufferSize = 2147483647;
            httpTransport.AllowCookies = false;
            httpTransport.HostNameComparisonMode = HostNameComparisonMode.StrongWildcard;
            httpTransport.TransferMode = TransferMode.Buffered;
            binding.Elements.Add(httpTransport);

            return binding;
        }
        
    }
}
