﻿using Cassandra;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Cassandra.Data.Linq;
using System.Security.Cryptography.X509Certificates;
using System.IO;
using System.Net.Security;
using System.Diagnostics;

namespace Curse.Cassandra
{
    public class CassandraConfiguration
    {

        public static CassandraConfiguration[] Configurations;

        public int RegionIdentifier
        {
            get;
            set;
        }

        public string RegionKey
        {
            get;
            set;
        }


        public string RegionGroup
        {
            get;
            set;
        }

        public string[] Addresses
        {
            get;
            set;
        }

        public Cluster Cluster
        {
            get;
            private set;
        }
        
        public bool IsLocal
        {
            get;
            private set;
        }

        public string LocalDataCenterName
        {
            get;
            set;
        }

        public string Username
        {
            get;
            set;
        }

        public string Password
        {
            get;
            set;
        }

        public bool IsEncrypted
        {
            get;
            set;
        }
        
        static bool ValidateCert(Object sender, X509Certificate certificate, X509Chain chain, SslPolicyErrors sslPolicyErrors)
        {
            return true;
        }

        public static void Initialize(string localRegionIdentifier, IEnumerable<CassandraConfiguration> configurations)
        {            
            Configurations = configurations.ToArray();
            foreach (var config in Configurations)
            {

                var builder = Cluster.Builder()
                    .WithLoadBalancingPolicy(new DCAwareRoundRobinPolicy(config.LocalDataCenterName, 2))
                    .AddContactPoints(config.Addresses);                               

                if (config.Username != null)
                {
                    builder = builder.WithAuthProvider(new PlainTextAuthProvider(config.Username, config.Password));                                     
                }

                
                config.Cluster = builder.Build();
                
                config.Cluster.Configuration.PoolingOptions.SetMaxConnectionsPerHost(HostDistance.Local, 1000);
                config.Cluster.Configuration.QueryOptions.SetConsistencyLevel(ConsistencyLevel.LocalQuorum);                

                if (config.RegionKey.Equals(localRegionIdentifier))
                {
                    config.IsLocal = true;
                }                
            }

            if (Configurations.Count(p => p.IsLocal) != 1)
            {
                throw new Exception("You must define only one local cassandra configuration element.");
            }
        }

    }
}
