﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.Cassandra
{
    public static class CassandraUtilities
    {
        public static string GetCsqlType(Type type)
        {
            if (type.IsGenericType && type.GetGenericTypeDefinition() == typeof(Nullable<>))
            {
                type = Nullable.GetUnderlyingType(type); 
            }            
            var typeCode = Type.GetTypeCode(type);

            switch (typeCode)
            {
                case TypeCode.Boolean:
                    return "boolean";
                case TypeCode.Byte:
                case TypeCode.Int32:
                case TypeCode.Int16:
                    return "int";
                case TypeCode.Int64:
                    return "bigint";
                case TypeCode.String:
                    return "varchar";
                case TypeCode.DateTime:
                    return "timestamp";
                case TypeCode.Double:
                    return "double";
                case TypeCode.Single:
                    return "float";
                default:
                    throw new ArgumentException("Unknown CSQL type conversion for: " + typeCode.ToString());
            }
        }
    }
}
