﻿using Cassandra;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.Cassandra
{
    public static class RowExtensions
    {
        public static int GetInt(this Row row, string name)
        {
            if(row.IsNull(name))
            {
                return 0;
            }

            return row.GetValue<int>(name);
        }

        public static DateTime GetDateTime(this Row row, string name)
        {
            if (row.IsNull(name))
            {
                return default(DateTime);
            }

            return row.GetValue<DateTime>(name);
        }

        public static bool GetBool(this Row row, string name, bool defaultValue = false)
        {
            if (row.IsNull(name))
            {
                return defaultValue;
            }

            return row.GetValue<bool>(name);
        }
    }
}
