﻿using System;
using System.Collections.Generic;
using System.Net;
using Amazon;
using Amazon.CloudFront.Model;

namespace Curse.CloudFront
{
    public class CloudFrontApi
    {
        private static string _accessKey;
        private static string _secretAccessKey;
        private static string _distributionID;
        private static bool _isInitialized;

        public static void Initialize(string apiKey, string secretAccessKey, string distributionID)
        {
            _accessKey = apiKey;
            _secretAccessKey = secretAccessKey;
            _distributionID = distributionID;
            _isInitialized = true;
        }

        public static bool InvalidateUrls(string[] urls)
        {
            if (!_isInitialized)
            {
                throw new Exception("CloudFrontApi must be initialized!");
            }

            var relativeUrls = new List<string>();
            foreach (var url in urls)
            {
                var uri = new Uri(url);
                if (uri.IsAbsoluteUri)
                {
                    relativeUrls.Add(uri.PathAndQuery);
                }
            }


            var batch = new InvalidationBatch
            {
                Paths = new Paths() { Items = relativeUrls, Quantity = relativeUrls.Count },
                CallerReference = Guid.NewGuid().ToString()
            };

            var req = new CreateInvalidationRequest(_distributionID, batch);

            using (var client = Amazon.AWSClientFactory.CreateAmazonCloudFrontClient(_accessKey, _secretAccessKey, RegionEndpoint.USEast1))
            {
                var resp = client.CreateInvalidation(req);
                return resp.HttpStatusCode == HttpStatusCode.Created;
            }
        }
    }

}
