﻿using Curse.Logging;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Curse.CloudQueue.Tests
{
    class Program
    {
        static void Main(string[] args)
        {

            Console.Write("Enter a queue config use: ");
            var name = Console.ReadLine();
            if (string.IsNullOrEmpty(name))
            {
                name = "Local";
            }

            var queueConfigurations = new List<QueueConfiguration>();
            queueConfigurations.Add(new QueueConfiguration
            {
                Addresses = new[] { "runner06a-hsv.curse.us", "runner07a-hsv.curse.us" },
                Username = "guest",
                Password = "guest",
                RegionIdentifier = 0,
                RegionKey = "Local",
                Port = 5672
            });

            //queueConfigurations.Add(new QueueConfiguration
            //{
            //    ClusterHostName = "rabbit.dev-replica.cursevoice.com",
            //    Username = "guest",
            //    Password = "guest",
            //    RegionIdentifier = 1,
            //    RegionKey = "LocalReplica",
            //    Port = 5672
            //});
            QueueConfiguration.Initialize(name, queueConfigurations, null, null);
            TestWorkerMessages();
            Console.ReadLine();
            _isAlive = false;
            CloudQueueInstanceManager.CloseConnections();
            
            return;            
            
            while(true)
            {
                Thread.Sleep(100);
                Console.Write("Enter a message: ");
                var message = Console.ReadLine();
                Console.WriteLine("Choose a destination region: ");
                Console.WriteLine("1. Local");
                Console.WriteLine("2. LocalReplica");
                var choice = Console.ReadKey(true).Key;
                int regionID = 0;
                if (choice == ConsoleKey.D1)
                {
                    regionID = 0;
                }
                else
                {
                    regionID = 1;
                }
                Console.WriteLine("Sending a message to region " + regionID + "...");
                
                new TestRoutedQueueMessage() { DestinationRegionID = regionID, DestinationServerName = Environment.MachineName, TestMessage = message }.Enqueue();
                
                
            }
            
        }

        static void TestWorkerMessages()
        {
            TestWorkerQueueMessage.StartProcessor(ProcessMessage);
            new Thread(LoopWorkerMessages).Start();           
        }

        static void TestRoutedMessages()
        {
            TestRoutedQueueMessage.StartProcessor(ProcessMessage);
            new Thread(LoopMessages).Start();            
        }

        private static bool _isAlive = true;

        private static void LoopMessages()
        {
            while (_isAlive)
            {
                try
                {
                    new TestRoutedQueueMessage() { DestinationRegionID = 0, DestinationServerName = Environment.MachineName, TestMessage = "Test At " + DateTime.UtcNow }.Enqueue();
                }
                catch (Exception ex)
                {
                    Console.WriteLine("Failure!");
                }

                Thread.Sleep(100);
            }
        }

        static void ProcessMessage(TestRoutedQueueMessage message)
        {
            Console.WriteLine("Received message: " + message.TestMessage);

            Thread.Sleep(10000);
        }


        private static void LoopWorkerMessages()
        {
            while (_isAlive)
            {
                try
                {
                    new TestWorkerQueueMessage() { TestMessage = "Test At " + DateTime.UtcNow }.Enqueue();
                }
                catch (Exception ex)
                {
                    Console.WriteLine("Failure!");
                }

                Thread.Sleep(1);
            }
        }

        static void ProcessMessage(TestWorkerQueueMessage message)
        {
            Console.WriteLine("Received message: " + message.TestMessage);            
        }
    }
}
