﻿using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Linq;

namespace Curse.CloudQueue
{
    public static class CloudQueueInstanceManager
    {
        static readonly ConcurrentBag<ICloudQueue> _queues = new ConcurrentBag<ICloudQueue>();

        public static void RegisterProcessor(ICloudQueue processor)
        {
            _queues.Add(processor);
        }

        public static void CloseConnections()
        {
            foreach (var processor in _queues)
            {
                processor.CloseConnections();
            }
        }

        public static IEnumerable<CloudQueueStats> GetQueueStats()
        {
            return _queues.Select(processor => processor.Stats);
        }
    }
}
