﻿namespace Curse.CloudQueue
{
    /// <summary>
    /// Responsible solely for queuing messages 
    /// </summary>
    /// <typeparam name="TMessage"></typeparam>
    public class CloudQueueManager<TMessage> where TMessage : ICloudQueueMessage
    {       
        protected readonly ICloudQueue<TMessage> Queue;

        public CloudQueueManager(bool isShoveled, bool isMachineRouted, bool isPersistent = false, int? retryLimit = null, int? mesageTtl = null, int? maxQueueLength = null, int? maxQueueBytes = null)
        {
            Queue = new RabbitQueue<TMessage>(CloudQueueMode.Publisher, typeof(TMessage).Name, isShoveled, isMachineRouted, isPersistent, false, retryLimit, mesageTtl, maxQueueLength, maxQueueBytes);
        }

        public void Enqueue(TMessage value, string machineName = null, int? regionID = null)
        {
            Queue.Enqueue(value, machineName, regionID);
        }        
    }
}
