﻿using System;

namespace Curse.CloudQueue
{
    

    /// <summary>
    ///  Responsible for dequeing messaging, and processing them.
    /// </summary>
    /// <typeparam name="TMessage"></typeparam>
    public class CloudQueueProcessor<TMessage>
        where TMessage : ICloudQueueMessage
    {
        protected ICloudQueue<TMessage> Queue;

        public CloudQueueProcessor(bool isShoveled, bool isMachineRouted, bool isPersistent, bool isAcknowledged, int? retryLimit = null, int? messageTtl = null, int? maxQueueLength = null, int? maxParallel = null, double? prefetchMultipler = null, int? maxQueueBytes = null)
        {
            Queue = new RabbitQueue<TMessage>(CloudQueueMode.Consumer, typeof(TMessage).Name, isShoveled, isMachineRouted, isPersistent, isAcknowledged, retryLimit, messageTtl, maxQueueLength, maxParallel, prefetchMultipler, maxQueueBytes);            
        }                

        public void Start(Action<TMessage> messageProcessor)
        {
            Queue.StartProcessor(messageProcessor);
        }
    }
}
