﻿using System;

namespace Curse.CloudQueue
{
    public class CloudQueueProcessorAttribute : Attribute
    {
        public int MaxParallel { get; set; }
        public bool IsAcknowledged { get; set; }
        public double PrefetchMultiplier { get; set; }

        public CloudQueueProcessorAttribute(int maxParallel, bool isAcknowledged)
        {
            MaxParallel = maxParallel;
            IsAcknowledged = isAcknowledged;
        }

        public CloudQueueProcessorAttribute(bool isAcknowledged)
        {            
            IsAcknowledged = isAcknowledged;
        }
    }
}
