﻿using System;

namespace Curse.CloudQueue
{
    public interface ICloudQueue
    {
        void CloseConnections();
        int CurrentlyProcessing { get; }
        long TotalProcessed { get; }
        string Name { get; }
        CloudQueueStats Stats { get; }        
    }

    public interface ICloudQueue<T> : ICloudQueue
        where T : ICloudQueueMessage
    {
        void StartProcessor(Action<T> processor);        
        void Enqueue(T value, string destinationServerName = null, int? destinationRegionID = null);        
    }
}
