﻿using System.Xml.Serialization;

namespace Curse.CloudQueue
{
    [XmlRoot("Queue")]
    public class QueueConfigurationCollection
    {
        /// <summary>
        /// When set, all regionally routed queues are mapped to the local region. 
        /// This should only be set on dev or staging builds.
        /// </summary>
        [XmlElement]
        public bool SingleRegionMode { get; set; }

        [XmlElement("TypeRoute")]        
        public QueueTypeRoute[] TypeRouting { get; set; }

        [XmlElement("Cluster")]
        public QueueConfiguration[] Configurations { get; set; }
    }
}
