﻿using System;
using Curse.Logging;
using RabbitMQ.Client;

namespace Curse.CloudQueue
{
    public static class RabbitExtensions
    {
        public static void CloseSafely(this IConnection connection, LogCategory logger, int timeoutMillisconds = 500)
        {
            if (connection == null)
            {
                return;
            }

            try
            {
                if (connection.IsOpen)
                {
                    logger.Info("Closing connection");
                    connection.Close(timeoutMillisconds);
                }
                else
                {
                    logger.Info("Aborting connection");
                    connection.Abort(timeoutMillisconds);
                }
            }
            catch (Exception ex)
            {
                logger.Error(ex, "Failed to close connection!");
            }
        }

        public static void CloseSafely(this IModel model, LogCategory logger)
        {
            if (model == null)
            {
                return;
            }

            try
            {
                if (model.IsOpen)
                {
                    logger.Info("Closing model");
                    model.Close();
                }
                else
                {
                    logger.Info("Aborting model");
                    model.Abort();
                }                
            }
            catch (Exception ex)
            {
                Logger.Error(ex);
            }
        }
    }
}
