﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Curse.CloudSearch.Tests.SearchTypes;

namespace Curse.CloudSearch.Tests
{
    static class ManualTest
    {
        private static readonly Random Random = new Random();

        public static void Run()
        {
            Console.WriteLine("How many rows of data would you like to import? (Increments of 10,000 required)");
            var sampleVal = Console.ReadLine();
            int samplePct;
            if (!int.TryParse(sampleVal, out samplePct) || samplePct % 10000 != 0)
            {
                Console.WriteLine("Invalid sample percent: " + sampleVal);
                return;
            }
            Console.Clear();

            Console.WriteLine("Would you like to validate all imported data, against the search index? [Y|N]");
            var testSearchData = Console.ReadKey(true).Key == ConsoleKey.Y;
            Console.Clear();

            Console.WriteLine("Do you want to import the character search index? [Y|N]");

            if (Console.ReadKey(true).Key == ConsoleKey.Y)
            {
                CharacterSearchTypeUtilities.PopulateIndex(samplePct, Random, testSearchData);
                Thread.Sleep(1000);
            }

            Console.WriteLine("Do you want to import the user search index? [Y|N]");

            if (Console.ReadKey(true).Key == ConsoleKey.Y)
            {
                UserSearchTypeUtilities.PopulateIndex(samplePct, Random, testSearchData);
                Thread.Sleep(1000);
            }

            Console.WriteLine("Do you want to import the email search index? [Y|N]");
            if (Console.ReadKey(true).Key == ConsoleKey.Y)
            {
                EmailSearchTypeUtilities.PopulateIndex(samplePct, Random, testSearchData);
                Thread.Sleep(1000);
            }

            while (true)
            {
                Console.Clear();
                Console.Write("Enter a username to search for: ");
                var input = Console.ReadLine();
                TestAutoCompleteSearch(input, new[] { "Wyrmrest Accord", "Emerald Dream" }, new[] { "NA" });
                Console.WriteLine();
                Console.WriteLine("Press any key to search again...");
                Console.ReadKey(true);

            }
        }

        static void TestAutoCompleteSearch(string queryString, string[] gameServers = null, string[] regions = null)
        {
            queryString = queryString.ToLowerInvariant();

            var characterClient = CharacterSearchType.GetClient();
            var emailClient = EmailSearchType.GetClient();
            var userClient = UserSearchType.GetClient();

            var characterResults = characterClient.SearchCharacters(queryString, regions, gameServers, 10);
            var characterMatches = characterClient.SearchCharacters(queryString, regions, gameServers, 10, true);
            var userResults = userClient.SearchUsers(queryString, 5);
            var userMatches = userClient.SearchUsers(queryString, 5, true);
            var emailResults = emailClient.SearchEmails(queryString);
            var emailMatches = emailClient.SearchEmails(queryString, true);


            Console.WriteLine("-----------------------------------------------------------------------------------------");
            Console.WriteLine("Email Search Results");
            Console.WriteLine();


            Console.WriteLine("Term Search: ");
            if (!emailResults.Documents.Any())
            {
                Console.WriteLine("None :(");
            }
            foreach (var doc in emailResults.Documents)
            {
                var hit = emailResults.Hits.FirstOrDefault(p => p.Id == doc.UserID.ToString());
                Console.WriteLine(doc.EmailAddress + ". Score: " + hit.Score + ". Friend Count: " + doc.FriendCount);
            }

            Console.WriteLine();
            Console.WriteLine("Match Search");
            if (!emailMatches.Documents.Any())
            {
                Console.WriteLine("None :(");
            }
            foreach (var doc in emailMatches.Documents)
            {
                var hit = emailMatches.Hits.FirstOrDefault(p => p.Id == doc.UserID.ToString());
                Console.WriteLine(doc.EmailAddress + ". Score: " + hit.Score + ". Friend Count: " + doc.FriendCount);
            }


            Console.WriteLine();
            Console.WriteLine("-----------------------------------------------------------------------------------------");
            Console.WriteLine("Users Search Results");
            Console.WriteLine();

            Console.WriteLine("Term Search: ");
            if (!userResults.Documents.Any())
            {
                Console.WriteLine("None :(");
            }
            foreach (var doc in userResults.Documents)
            {
                var hit = userResults.Hits.FirstOrDefault(p => p.Id == doc.UserID.ToString());
                Console.WriteLine("- " + doc.Username + ". Score: " + hit.Score + ". Friend Count: " + doc.FriendCount);
            }

            Console.WriteLine();
            Console.WriteLine("Match Search: ");
            if (!userMatches.Documents.Any())
            {
                Console.WriteLine("None :(");
            }
            foreach (var doc in userMatches.Documents)
            {
                var hit = userMatches.Hits.FirstOrDefault(p => p.Id == doc.UserID.ToString());
                Console.WriteLine("- " + doc.Username + ". Score: " + hit.Score + ". Friend Count: " + doc.FriendCount);
            }

            Console.WriteLine();
            Console.WriteLine("-----------------------------------------------------------------------------------------");
            Console.WriteLine("Character Search Results");
            Console.WriteLine();

            Console.WriteLine("Term Search:");
            if (!characterResults.Documents.Any())
            {
                Console.WriteLine("None :(");
            }
            foreach (var doc in characterResults.Documents)
            {
                var id = doc.UniqueKey;
                var hit = characterResults.Hits.FirstOrDefault(p => p.Id == id);
                Console.WriteLine("- " + doc.CharacterName + (doc.ServerName != null ? "@" + doc.ServerRegion + "-" + doc.ServerName : "") + ". Score: " + hit.Score + ". Friend Count: " + doc.FriendCount);
            }

            Console.WriteLine();
            Console.WriteLine("Match Search:");
            if (!characterMatches.Documents.Any())
            {
                Console.WriteLine("None :(");
            }
            foreach (var doc in characterMatches.Documents)
            {
                var id = doc.UniqueKey;
                var hit = characterMatches.Hits.FirstOrDefault(p => p.Id == id);
                Console.WriteLine("- " + doc.CharacterName + (doc.ServerName != null ? "@" + doc.ServerRegion + "-" + doc.ServerName : "") + ". Score: " + hit.Score + ". Friend Count: " + doc.FriendCount);
            }

            Console.WriteLine();
            Console.WriteLine("-----------------------------------------------------------------------------------------");

            var totalElapsed = userResults.ElapsedMilliseconds + characterResults.ElapsedMilliseconds +
                               emailResults.ElapsedMilliseconds;
            Console.WriteLine("Term Searches completed in {0} ms", totalElapsed);

            totalElapsed = emailMatches.ElapsedMilliseconds + characterMatches.ElapsedMilliseconds +
                                 userMatches.ElapsedMilliseconds;
            Console.WriteLine("Match Searches completed in {0}ms", totalElapsed);

        }

    }
}
