﻿namespace Curse.CloudSearch.Tests.SearchTypes
{
    public class CharacterSearchType : CloudSearchManager<CharacterSearchType>
    {

        
        [CloudSearchProperty(SearchType = CloudSearchType.AutoComplete)]
        public string CharacterName
        {
            get;
            set;
        }

        [CloudSearchProperty(SearchType = CloudSearchType.ExactMatchOnly)]
        public string ServerName
        {
            get;
            set;
        }

        [CloudSearchProperty(SearchType = CloudSearchType.ExactMatchOnly)]
        public string ServerRegion
        {
            get;
            set;
        }

        [CloudSearchProperty(IsIdentifier = true)]
        public string UniqueKey
        {
            get;
            set;
        }

        public int UserID
        {
            get;
            set;
        }

        public int FriendCount
        {
            get;
            set;
        }
               
        public CharacterSearchType GenerateUniqueKey()
        {
            UniqueKey = "ID:" + UserID + ";Term:" + CharacterName;
            return this;
        }                

        public static readonly CharacterSearchType Instance = new CharacterSearchType();
        
    }
}
