﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using System.Threading;
using Nest;

namespace Curse.CloudSearch.Tests.SearchTypes
{
    class EmailSearchTypeUtilities
    {
        public static void PopulateIndex(int rowLimit, Random random, bool testSearching = false)
        {
            var throwaway = new List<string>();
            PopulateIndex(rowLimit, random, ref throwaway, testSearching);
        }
        public static void PopulateIndex(int rowLimit, Random random, ref List<string> possibleSearches, bool testSearching = false)
        {
            EmailSearchType.DeleteIndex();
            EmailSearchType.SetupIndex();

            var client = EmailSearchType.GetClient();
            var list = new List<EmailSearchType>();
            using (var conn = new SqlConnection("Data Source=sql02-dev.curse.us;Initial Catalog=AuthService;Integrated Security=true;MultipleActiveResultSets=True;Max Pool Size=1024;MultiSubnetFailover=True;"))
            {
                conn.Open();
                using (var cmd = conn.CreateCommand())
                {
                    cmd.CommandText = "select TOP(" + rowLimit + ") useremails._uid, useremails._email from useremails inner join userprofiles on userprofiles._uid = useremails._uid where useremails._id = userprofiles._defaultEmail";
                    using (var reader = cmd.ExecuteReader())
                    {
                        var i = 0;
                        while (reader.Read())
                        {
                            var model = new EmailSearchType
                            {
                                EmailAddress = reader.GetString(1),
                                UserID = reader.GetInt32(0),
                                FriendCount = random.Next(0, 120)
                            };

                            list.Add(model);
                            possibleSearches.Add(model.EmailAddress);

                            if (++i % 10000 == 0)
                            {
                                Console.WriteLine("Finished " + i.ToString("###,##0"));
                                var result = client.IndexMany(list);

                                if (!result.IsValid)
                                {
                                    Console.WriteLine("Index operation failed! Press any key to continue...");
                                    Console.ReadKey();
                                }

                                if (testSearching)
                                {
                                    Console.WriteLine("Testing Search Index ...");
                                    Thread.Sleep(1000);
                                    var searchCounter = 0;
                                    foreach (var user in list)
                                    {
                                        if (++searchCounter % 100 == 0)
                                        {
                                            Console.Title = (searchCounter / (double)list.Count).ToString("P0") + " completed...";
                                        }
                                        ValidateItem(user);
                                    }
                                }

                                list.Clear();
                            }
                        }
                    }
                }

                if (list.Any())
                {
                    client.IndexMany(list);
                }
            }

        }

        private static void ValidateItem(EmailSearchType item)
        {
            if (item.EmailAddress.Length < 2)
            {
                Console.WriteLine("Skipping username. It is not really very valid: " + item.EmailAddress);
                return;
            }

            var emailClient = EmailSearchType.GetClient();
            if (emailClient.SearchEmails(item.EmailAddress).Documents.All(e => e.UserID != item.UserID))
            {
                Console.WriteLine("Full name search failed for: " + item.EmailAddress);
            }
        }
    }
}
