﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using System.Threading;
using Nest;

namespace Curse.CloudSearch.Tests.SearchTypes
{
    static class UserSearchTypeUtilities
    {
        private const int ExactMatchRowLimit=10;
        private const int AutocompleteRowLimit=100;

        public static void PopulateIndex(int rowLimit, Random random, bool testSearching = false)
        {
            var throwaway = new List<string>();
            PopulateIndex(rowLimit, random, ref throwaway, testSearching);
        }

        public static void PopulateIndex(int rowLimit, Random random, ref List<string> possibleSearches, bool testSearching = false)
        {
            UserSearchType.DeleteIndex();
            UserSearchType.SetupIndex();

            var client = UserSearchType.GetClient();
            var list = new List<UserSearchType>();

            using (var conn = new SqlConnection("Data Source=sql02-dev.curse.us;Initial Catalog=AuthService;Integrated Security=true;MultipleActiveResultSets=True;Max Pool Size=1024;MultiSubnetFailover=True;"))
            {
                conn.Open();
                using (var cmd = conn.CreateCommand())
                {
                    cmd.CommandText = "select top " + rowLimit + " _uid, _username from users order by _uid";
                    using (var reader = cmd.ExecuteReader())
                    {
                        var i = 0;
                        while (reader.Read())
                        {
                            var friendCount = random.Next(0, 120);

                            var model = new UserSearchType
                            {
                                Username = reader.GetString(1),
                                UserID = reader.GetInt32(0),
                                FriendCount = friendCount
                            };


                            list.Add(model);
                            possibleSearches.Add(model.Username);

                            if (++i % 10000 == 0)
                            {
                                var result = client.IndexMany(list);
                                if (!result.IsValid)
                                {
                                    Console.WriteLine("Index operation failed! Press any key to continue...");
                                    Console.ReadKey();
                                }

                                if (testSearching)
                                {
                                    Console.WriteLine("Testing Search Index ...");
                                    Thread.Sleep(1000);
                                    var searchCounter = 0;
                                    foreach (var user in list)
                                    {
                                        if (++searchCounter % 100 == 0)
                                        {
                                            Console.Title = (searchCounter / (double)list.Count).ToString("P0") + " completed...";
                                        }
                                        ValidateItem(user);
                                    }
                                }

                                list.Clear();
                                Console.WriteLine("Finished " + i.ToString("###,##0"));
                            }
                        }
                    }
                }

                if (list.Any())
                {
                    client.IndexMany(list);
                }
            }

        }

        private static void ValidateItem(UserSearchType item)
        {
            if (item.Username.Length < 2)
            {
                Console.WriteLine("Skipping username. It is not really very valid: " + item.Username);
                return;
            }

            var userClient = UserSearchType.GetClient();

            if (userClient.SearchUsers(item.Username, ExactMatchRowLimit).Documents.All(u => u.UserID != item.UserID))
            {
                Console.WriteLine("Full name search failed for: " + item.Username);
            }

            if (item.Username.Length < 3)
            {
                return;
            }

            var partialSearch = item.Username.Substring(0, item.Username.Length - 1);
            if (userClient.SearchUsers(partialSearch, AutocompleteRowLimit).Documents.All(u => u.UserID != item.UserID))
            {
                Console.WriteLine("Partial name search failed for user '" + item.Username + "' using search term '" + partialSearch + "'");
            }
        }

    }
}
