﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using Nest;

namespace Curse.CloudSearch
{
    public static class CloudSearchConstants
    {
        public static readonly string AutocompleteSuffix = "autocomplete";
        public static readonly string SortSuffix = "sort";
        public static readonly string AutocompleteAnalyzerName = "autocomplete_analyzer";
        public static readonly string LowercaseAnalyzerName = "lowercase_analyzer";
        public static readonly string LowercaseSuffix = "lowercase";
    }

    public static class CloudSearchExtensions
    {
        public static PropertiesDescriptor<TModel> CreateAutocompleteField<TModel>(this PropertiesDescriptor<TModel> descriptor, AnalyzedStringPropertyAttribute attribute) where TModel : class
        {
            var coreProperties = new CorePropertiesDescriptor<TModel>().String(s => s.Name(attribute.Name).Index(FieldIndexOption.Analyzed));
            if (attribute.Autocomplete)
            {
                coreProperties = coreProperties.String(s => s
                    .Name(CloudSearchConstants.AutocompleteSuffix)
                    .Analyzer(CloudSearchConstants.AutocompleteAnalyzerName)
                    .SearchAnalyzer(CloudSearchConstants.LowercaseAnalyzerName));
            }
            if (attribute.Sortable)
            {
                coreProperties = coreProperties.String(s => s
                    .Name(CloudSearchConstants.SortSuffix)
                    .Analyzer(CloudSearchConstants.LowercaseAnalyzerName));
            }
            if (attribute.Lowercase)
            {
                coreProperties = coreProperties.String(s => s
                    .Name(CloudSearchConstants.LowercaseSuffix)
                    .Analyzer(CloudSearchConstants.LowercaseAnalyzerName));
            }

            return descriptor.MultiField(mf => mf
                .Name(attribute.Name)
                .Fields(f => coreProperties));
        }

        public static PropertiesDescriptor<TModel> CreateAutocompleteFields<TModel>(this PropertiesDescriptor<TModel> descriptor) where TModel : class
        {
            var response = descriptor;
            foreach (var attribute in typeof (TModel).GetProperties().Select(p => p.GetCustomAttribute<AnalyzedStringPropertyAttribute>()).Where(a => a != null))
            {
                response = CreateAutocompleteField(response, attribute);
            }
            return response;
        }
    }
}
