﻿using Nest;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.CloudSearch
{
    public class CloudSearchResult<T> where T : class
    {
        public static readonly CloudSearchResult<T>[] EmptyList = new CloudSearchResult<T>[0];

        public CloudSearchResult()
        {

        }

        public CloudSearchResult(T value, double score)
        {
            Value = value;
            Score = score;            
        }

        public T Value { get; set; }
        public double Score { get; set; }
        
        public static CloudSearchResult<T>[] CreateFromQuery(ISearchResponse<T> response)
        {
            

            var list = new List<CloudSearchResult<T>>();
            var docs = response.Documents.ToArray();
            var hits = response.Hits.ToArray();
            for (int i = 0; i < docs.Length; i++ )
            {
                var result = new CloudSearchResult<T>(docs[i], hits[i].Score);
                list.Add(result);
            }
            

            return list.ToArray();
        }
    }
}
