﻿using System;
using Nest;

namespace Curse.CloudSearch
{
    public class AnalyzedStringPropertyAttribute : Attribute
    {
        public string Name { get; set; }

        public bool Autocomplete { get; set; }

        public bool Sortable { get; set; }

        public bool Lowercase { get; set; }

        public AnalyzedStringPropertyAttribute(string name)
        {
            Name = name;
            Autocomplete = true;
            Sortable = true;
            Lowercase = false;
        }
    }

    public class ElasticNestedObjectAttribute : Attribute
    {
        public string Name { get; set; }

        public bool Autocomplete { get; set; }

        public bool Sort { get; set; }

        public ElasticNestedObjectAttribute(string name)
        {
            
        }
    }

    public class ElasticObjectAttribute : Attribute
    {
        public string Name { get; set; }
        public ElasticObjectAttribute(string name)
        {
            
        }
    }

}
